package gov.va.med.mhv.usermgmt.service;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.usermgmt.main.registry.UnknownMhvPatientException;
import gov.va.med.mhv.usermgmt.main.registry.Patient;
import gov.va.med.mhv.usermgmt.main.registry.Status;
import gov.va.med.mhv.usermgmt.common.enums.StatusType;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.main.registry.BaseProcessor;


public abstract class MoveInboundProcessor extends BaseProcessor {

	@Autowired
	private PatientService patientService;
	
	@Autowired
	private PatientConverter patientConverter;

    protected static boolean isNACK(Status status) 
    {
        return (status != null) && !StatusType.Ok.equals(status.getStatusType());
    }

    protected static boolean isACK(Status status) 
    {
        return (status != null) && StatusType.Ok.equals(status.getStatusType());
    }

//   /**
//     * @return Returns the patientIdentityProxy.
//     */
//    public PatientService getPatientIdentityServiceProxy() {
//        return getProcessingHelper().getPatientIdentityService();
//    }

    protected gov.va.med.mhv.common.api.dto.PatientDTO findPatient(
        Patient patient) 
    { 
        return findPatient(patient, true);
    }
    protected gov.va.med.mhv.common.api.dto.PatientDTO findPatient(
        Patient patient, boolean required) 
    { 
    	ResponseUtil<gov.va.med.mhv.common.data.model.Patient> response = new ResponseUtil<gov.va.med.mhv.common.data.model.Patient>();
		patientService.getPatientByIcn(patient.getIcn(), response);
		gov.va.med.mhv.common.api.dto.PatientDTO transferPatient = null;
		if(response.isSuccess()) {
			if(response.getPojoObject() != null) {
				transferPatient = patientConverter.convertDomainPatient(response.getPojoObject());
			}
		}
        if ((transferPatient == null) && required) {
            throw new UnknownMhvPatientException(createUnknownMhvPatientMessage(
                patient.getIcn()));
        }
        return transferPatient;
    }
    
	private String createUnknownMhvPatientMessage(String icn) 
        throws IllegalArgumentException
	{
		StringBuffer buf = new StringBuffer(
            "Could not find MHV patient with ICN (");
		buf.append(icn).append(")");
		return buf.toString();
	}
	
	public String createUnknownMhvPatientsMessage(String icn1, String icn2) 
        throws IllegalArgumentException
	{
		StringBuffer buf = new StringBuffer(
            "Could not find MHV patients with ICNs (");
		buf.append(icn1).append(", ").append(icn2).append(")");
		return buf.toString();
	}

}
